<#ibiztemplate>
TARGET=PSAPPDEUILOGIC
</#ibiztemplate>
<#ibizinclude>
../@MACRO/APP-UI-LOGIC-NODE.txt
</#ibizinclude>
import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
        <#if logicNode.getLogicNodeType() == 'DELOGIC' && logicNode.getDstPSAppDELogic?? && logicNode.getDstPSAppDELogic()?? && logicNode.getDstPSAppDELogic().getPSAppDataEntity?? && logicNode.getDstPSAppDELogic().getPSAppDataEntity()??>
            <#if logicNode.getDstPSAppDELogic().getLogicHolder() == 2 || logicNode.getDstPSAppDELogic().getLogicHolder() == 3>
                <#if !P.exists("importService333", logicNode.getDstPSAppDELogic().codeName, "")>
import ${srfclassname('${logicNode.getDstPSAppDELogic().getCodeName()}')}Logic from '@/service/${srffilepath2(logicNode.getDstPSAppDELogic().getPSAppDataEntity().getCodeName())}/${srffilepath2(logicNode.getDstPSAppDELogic().getCodeName())}-logic';
                </#if>
            </#if>
        </#if>
    </#list>
</#if>
/**
 * ${item.name}
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic-base.ts.ftl 生成
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UILogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UILogicBase {

    /**
     * Creates an instance of  ${item.codeName}Base.
     * 
     * @param {*} [opts={}]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected logicParams: any[] = [
<#if item.getPSDEUILogicParams?? && item.getPSDEUILogicParams()??>
    <#list item.getPSDEUILogicParams() as logicParam>
        {
            name: '${logicParam.name}',
            codeName: '${logicParam.codeName}',
        <#if logicParam.isActiveContainerParam?? && logicParam.isActiveContainerParam()>
            activeContainerParam: true,
        </#if>
        <#if logicParam.isActiveCtrlParam?? && logicParam.isActiveCtrlParam()>
            activeCtrlParam: true,
        </#if>
        <#if logicParam.isActiveViewParam?? && logicParam.isActiveViewParam()>
            activeViewParam: true,
        </#if>
        <#if logicParam.isAppGlobalParam?? && logicParam.isAppGlobalParam()>
            appGlobalParam: true,
        </#if>
        <#if logicParam.isApplicationParam?? && logicParam.isApplicationParam()>
            applicationParam: true,
        </#if>
        <#if logicParam.isCtrlParam?? && logicParam.isCtrlParam()>
            ctrlParam: true,
        </#if>
        <#if logicParam.isDefault?? && logicParam.isDefault()>
            default: true,
        </#if>
        <#if logicParam.isEntityParam?? && logicParam.isEntityParam()>
            entityParam: true,
        </#if>
        <#if logicParam.isEntityListParam?? && logicParam.isEntityListParam()>
            entityListParam: true,
        </#if>
        <#if logicParam.isEntityPageParam?? && logicParam.isEntityPageParam()>
            entityPageParam: true,
        </#if>
        <#if logicParam.isFilterParam?? && logicParam.isFilterParam()>
            filterParam: true,
        </#if>
        <#if logicParam.isNavContextParam?? && logicParam.isNavContextParam()>
            navContextParam: true,
        </#if>
        <#if logicParam.isSimpleParam?? && logicParam.isSimpleParam()>
            simpleParam: true,
        </#if>
        <#if logicParam.isSimpleListParam?? && logicParam.isSimpleListParam()>
            simpleListParam: true,
        </#if>
        <#if logicParam.isRouteViewSessionParam?? && logicParam.isRouteViewSessionParam()>
            routeViewSessionParam: true,
        </#if>
        <#if logicParam.isViewNavDataParam?? && logicParam.isViewNavDataParam()>
            viewNavDataParam: true,
        </#if>
        <#if logicParam.isViewSessionParam?? && logicParam.isViewSessionParam()>
            viewSessionParam: true,
        </#if>
        <#if logicParam.isLastReturnParam?? && logicParam.isLastReturnParam()>
            lastReturnParam: true
        </#if>
        },
    </#list>
</#if>
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            <#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>
            await this.execute_${item.getStartPSDEUILogicNode().codeName?lower_case}_node(actionContext);
            <#else>
            throw new Error('没有开始节点');
            </#if>
            return actionContext.getResult();
        } catch (error: any) {
            <#noparse>throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);</#noparse>
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
    <@executenode logicNode/>
    
    </#list>
</#if>

}